/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ThoughtGorgerEffectEnters
extends OneShotEffect {
    ThoughtGorgerEffectEnters() {
        super(Outcome.Benefit);
        this.staticText = "put a +1/+1 counter on it for each card in your hand. If you do, discard your hand.";
    }

    private ThoughtGorgerEffectEnters(ThoughtGorgerEffectEnters effect) {
        super((OneShotEffect)effect);
    }

    public ThoughtGorgerEffectEnters copy() {
        return new ThoughtGorgerEffectEnters(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent thoughtGorger = game.getPermanent(source.getSourceId());
        if (player == null || player.getHand().isEmpty() || thoughtGorger == null || !thoughtGorger.addCounters(CounterType.P1P1.createInstance(player.getHand().size()), source.getControllerId(), source, game)) {
            return false;
        }
        player.discard(player.getHand(), false, source, game);
        return true;
    }
}

