/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ThoughtLashExileLibraryEffect
extends OneShotEffect {
    ThoughtLashExileLibraryEffect() {
        super(Outcome.Detriment);
        this.staticText = "that player exiles all cards from their library";
    }

    private ThoughtLashExileLibraryEffect(ThoughtLashExileLibraryEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThoughtLashExileLibraryEffect copy() {
        return new ThoughtLashExileLibraryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, controller.getLibrary().size()));
            controller.moveCards((Cards)cards, Zone.EXILED, source, game);
            return true;
        }
        return false;
    }
}

