/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class ThoughtReflectionReplacementEffect
extends ReplacementEffectImpl {
    ThoughtReflectionReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "If you would draw a card, draw two cards instead";
    }

    private ThoughtReflectionReplacementEffect(ThoughtReflectionReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ThoughtReflectionReplacementEffect copy() {
        return new ThoughtReflectionReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getControllerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player you = game.getPlayer(event.getPlayerId());
        if (you != null) {
            you.drawCards(2, source, game, event);
        }
        return true;
    }
}

