/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ThoughtweftGambitEffect
extends OneShotEffect {
    private static FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public ThoughtweftGambitEffect() {
        super(Outcome.Benefit);
        this.staticText = "Tap all creatures your opponents control and untap all creatures you control";
    }

    private ThoughtweftGambitEffect(ThoughtweftGambitEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        boolean passed = false;
        Set opponents = game.getOpponents(source.getControllerId());
        Player controller = game.getPlayer(source.getControllerId());
        if (opponents != null) {
            for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
                if (!opponents.contains(creature.getControllerId())) continue;
                creature.tap(source, game);
            }
            passed = true;
        }
        if (controller != null) {
            for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
                if (!controller.getId().equals(creature.getControllerId())) continue;
                creature.untap(game);
            }
            passed = true;
        }
        return passed;
    }

    public ThoughtweftGambitEffect copy() {
        return new ThoughtweftGambitEffect(this);
    }
}

