/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class ThousandYearStormWatcher
extends Watcher {
    private final Map<UUID, List<MageObjectReference>> spellsThisTurn = new HashMap<UUID, List<MageObjectReference>>();

    public ThousandYearStormWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        MageObject object;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && (object = game.getObject(event.getTargetId())) != null && object.isInstantOrSorcery(game)) {
            UUID playerId = event.getPlayerId();
            List spellsCast = this.spellsThisTurn.getOrDefault(playerId, new ArrayList());
            spellsCast.add(new MageObjectReference(object, game));
            this.spellsThisTurn.put(playerId, spellsCast);
        }
    }

    public void reset() {
        for (List<MageObjectReference> mor : this.spellsThisTurn.values()) {
            mor.clear();
        }
        this.spellsThisTurn.clear();
    }

    public List<MageObjectReference> getSpellsThisTurn(UUID playerId) {
        return this.spellsThisTurn.getOrDefault(playerId, new ArrayList());
    }
}

