/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ThranLensEffect
extends ContinuousEffectImpl {
    ThranLensEffect() {
        super(Duration.WhileOnBattlefield, Layer.ColorChangingEffects_5, SubLayer.NA, Outcome.Benefit);
        this.staticText = "All permanents are colorless";
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent perm : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
            perm.getColor(game).setColor(ObjectColor.COLORLESS);
        }
        return true;
    }

    public ThranLensEffect copy() {
        return new ThranLensEffect(this);
    }

    private ThranLensEffect(ThranLensEffect effect) {
        super((ContinuousEffectImpl)effect);
    }
}

