/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class ThreeTreeScribeTriggeredAbility
extends TriggeredAbilityImpl {
    ThreeTreeScribeTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()));
        this.setTriggerPhrase("Whenever {this} or another creature you control leaves the battlefield without dying, ");
        this.addTarget((Target)new TargetControlledCreaturePermanent());
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private ThreeTreeScribeTriggeredAbility(ThreeTreeScribeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ThreeTreeScribeTriggeredAbility copy() {
        return new ThreeTreeScribeTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (!Zone.BATTLEFIELD.match(zEvent.getFromZone()) || Zone.GRAVEYARD.match(zEvent.getToZone())) {
            return false;
        }
        Permanent permanent = zEvent.getTarget();
        if (permanent == null) {
            return false;
        }
        if (permanent.getId().equals(this.getSourceId())) {
            return true;
        }
        return permanent.isCreature(game) && permanent.isControlledBy(this.getControllerId());
    }
}

