/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.util.CardUtil;

class ThreeWishesPlayFromExileEffect
extends AsThoughEffectImpl {
    ThreeWishesPlayFromExileEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.UntilYourNextTurn, Outcome.Benefit);
        this.staticText = "Until your next turn, you may play those cards";
    }

    private ThreeWishesPlayFromExileEffect(ThreeWishesPlayFromExileEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public ThreeWishesPlayFromExileEffect copy() {
        return new ThreeWishesPlayFromExileEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)0);
        ExileZone exile = game.getExile().getExileZone(exileId);
        return exile != null && this.getTargetPointer().getFirst(game, source) != null && this.getTargetPointer().getFirst(game, source).equals(sourceId) && source.isControlledBy(affectedControllerId) && game.getState().getZone(sourceId) == Zone.EXILED && exile.contains((Object)sourceId);
    }
}

