/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ThrowFromTheSaddleEffect
extends OneShotEffect {
    ThrowFromTheSaddleEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Target creature you control gets +1/+1 until end of turn. Put a +1/+1 counter on it instead if it's a Mount.";
    }

    private ThrowFromTheSaddleEffect(ThrowFromTheSaddleEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThrowFromTheSaddleEffect copy() {
        return new ThrowFromTheSaddleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        if (SubType.MOUNT.getPredicate().apply((MageObject)permanent, game)) {
            permanent.addCounters(CounterType.P1P1.createInstance(), source, game);
        } else {
            game.addEffect(new BoostTargetEffect(1, 1).setTargetPointer((TargetPointer)new FixedTarget(permanent.getId())), source);
        }
        return true;
    }
}

