/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.MageSingleton;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;

class ThunderousOratorEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();
    private static final List<MageSingleton> keywords;

    ThunderousOratorEffect() {
        super(Outcome.Benefit);
        this.staticText = "it gains flying until end of turn if you control a creature with flying. The same is true for first strike, double strike, deathtouch, indestructible, lifelink, menace, and trample";
    }

    private ThunderousOratorEffect(ThunderousOratorEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThunderousOratorEffect copy() {
        return new ThunderousOratorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<MenaceAbility> abilities = new ArrayList<MenaceAbility>();
        if (game.getBattlefield().count(filter, source.getControllerId(), source, game) > 0) {
            abilities.add(new MenaceAbility());
        }
        game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game).stream().filter(Objects::nonNull).map(p -> p.getAbilities(game)).flatMap(Collection::stream).filter(keywords::contains).distinct().forEach(abilities::add);
        if (abilities.isEmpty()) {
            return false;
        }
        for (Ability ability : abilities) {
            game.addEffect((ContinuousEffect)new GainAbilitySourceEffect(ability, Duration.EndOfTurn), source);
        }
        return true;
    }

    static {
        filter.add((Predicate)new AbilityPredicate(MenaceAbility.class));
        keywords = Arrays.asList(FlyingAbility.getInstance(), FirstStrikeAbility.getInstance(), DoubleStrikeAbility.getInstance(), DeathtouchAbility.getInstance(), IndestructibleAbility.getInstance(), LifelinkAbility.getInstance(), TrampleAbility.getInstance());
    }
}

