/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;
import mage.util.RandomUtil;

class TibaltsTrickeryEffect
extends OneShotEffect {
    TibaltsTrickeryEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell. Choose 1, 2, or 3 at random. Its controller mills that many cards, then exiles cards from the top of their library until they exile a nonland card with a different name than that spell. They may cast that card without paying its mana cost. Then they put the exiled cards on the bottom of their library in a random order.";
    }

    private TibaltsTrickeryEffect(TibaltsTrickeryEffect effect) {
        super((OneShotEffect)effect);
    }

    public TibaltsTrickeryEffect copy() {
        return new TibaltsTrickeryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            String spellName = spell.getName();
            Player controller = game.getPlayer(spell.getControllerId());
            game.getStack().counter(spell.getId(), source, game);
            if (controller != null) {
                ExileZone exile;
                int random = RandomUtil.nextInt((int)3) + 1;
                game.informPlayers(random + " was chosen at random");
                controller.millCards(random, source, game);
                Card cardToCast = null;
                HashSet<Card> cardsToExile = new HashSet<Card>();
                FilterCard filter = new FilterCard();
                filter.add(Predicates.not((Predicate)CardType.LAND.getPredicate()));
                filter.add(Predicates.not((Predicate)new NamePredicate(spellName)));
                for (Card card : controller.getLibrary().getCards(game)) {
                    cardsToExile.add(card);
                    if (!filter.match(card, game)) continue;
                    cardToCast = card;
                    break;
                }
                controller.moveCardsToExile(cardsToExile, source, game, true, source.getSourceId(), CardUtil.createObjectRelatedWindowTitle((Ability)source, (Game)game, null));
                if (cardToCast != null && controller.chooseUse(Outcome.PlayForFree, "Cast " + cardToCast.getLogName() + " for free?", source, game)) {
                    game.getState().setValue("PlayFromNotOwnHandZone" + cardToCast.getId(), (Object)Boolean.TRUE);
                    controller.cast(controller.chooseAbilityForCast(cardToCast, game, true), game, true, new ApprovingObject(source, game));
                    game.getState().setValue("PlayFromNotOwnHandZone" + cardToCast.getId(), null);
                }
                if ((exile = game.getExile().getExileZone(source.getSourceId())) != null) {
                    controller.putCardsOnBottomOfLibrary((Cards)exile, game, source, false);
                }
            }
            return true;
        }
        return false;
    }
}

