/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingCreature;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TidalFlatsEffect
extends OneShotEffect {
    private static final FilterAttackingCreature filter = new FilterAttackingCreature("attacking creature without flying");

    public TidalFlatsEffect() {
        super(Outcome.Benefit);
        this.staticText = "For each attacking creature without flying, its controller may pay {1}. If they don't, creatures you control blocking that creature gain first strike until end of turn";
    }

    private TidalFlatsEffect(TidalFlatsEffect effect) {
        super((OneShotEffect)effect);
    }

    public TidalFlatsEffect copy() {
        return new TidalFlatsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player == null) {
            return false;
        }
        ManaCostsImpl cost = new ManaCostsImpl("{1}");
        ArrayList<Permanent> affectedPermanents = new ArrayList<Permanent>();
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, player.getId(), game)) {
            cost.clearPaid();
            String message = "Pay " + cost.getText() + " for " + permanent.getLogName() + "? If you don't, creatures " + controller.getLogName() + " controls blocking it gain first strike until end of turn.";
            if (player.chooseUse(Outcome.Benefit, message, source, game)) {
                if (cost.pay(source, game, source, player.getId(), false, null)) {
                    game.informPlayers(player.getLogName() + " paid " + cost.getText() + " for " + permanent.getLogName());
                    continue;
                }
                game.informPlayers(player.getLogName() + " didn't pay " + cost.getText() + " for " + permanent.getLogName());
                affectedPermanents.add(permanent);
                continue;
            }
            game.informPlayers(player.getLogName() + " didn't pay " + cost.getText() + " for " + permanent.getLogName());
            affectedPermanents.add(permanent);
        }
        for (Permanent permanent : affectedPermanents) {
            CombatGroup group = game.getCombat().findGroup(permanent.getId());
            if (group == null) continue;
            for (UUID blockerId : group.getBlockers()) {
                Permanent blocker = game.getPermanent(blockerId);
                if (blocker == null || !Objects.equals(blocker.getControllerId(), controller.getId())) continue;
                GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(blocker.getId(), game));
                game.addEffect((ContinuousEffect)effect, source);
            }
        }
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)new AbilityPredicate(FlyingAbility.class)));
    }
}

