/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.CastOnlyIfConditionIsTrueAbility;
import mage.abilities.common.EntersBattlefieldAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.condition.common.SourceHasCounterCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.t.TidalInfluenceTriggeredAbility;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.mageobject.NamePredicate;

public final class TidalInfluence
extends CardImpl {
    private static final FilterPermanent filterName = new FilterPermanent("no permanents named Tidal Influence are on the battlefield");
    private static final FilterCreaturePermanent filterBlue = new FilterCreaturePermanent("all blue creatures");
    private static final Condition conditionCast;
    private static final Condition condition1;
    private static final Condition condition3;

    public TidalInfluence(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{U}");
        this.addAbility((Ability)new CastOnlyIfConditionIsTrueAbility(conditionCast));
        this.addAbility((Ability)new EntersBattlefieldAbility((Effect)new AddCountersSourceEffect(CounterType.TIDE.createInstance()), "with a tide counter on it."));
        this.addAbility((Ability)new BeginningOfUpkeepTriggeredAbility((Effect)new AddCountersSourceEffect(CounterType.TIDE.createInstance())));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new ConditionalContinuousEffect((ContinuousEffect)new BoostAllEffect(-2, 0, Duration.WhileOnBattlefield, filterBlue, false), condition1, "As long as there is exactly one tide counter on {this}, all blue creatures get -2/-0.")));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new ConditionalContinuousEffect((ContinuousEffect)new BoostAllEffect(2, 0, Duration.WhileOnBattlefield, filterBlue, false), condition3, "As long as there are exactly three tide counters on {this}, all blue creatures get +2/+0.")));
        this.addAbility((Ability)new TidalInfluenceTriggeredAbility());
    }

    private TidalInfluence(TidalInfluence card) {
        super((CardImpl)card);
    }

    public TidalInfluence copy() {
        return new TidalInfluence(this);
    }

    static {
        filterName.add((Predicate)new NamePredicate("Tidal Influence"));
        filterBlue.add((Predicate)new ColorPredicate(ObjectColor.BLUE));
        conditionCast = new PermanentsOnTheBattlefieldCondition(filterName, ComparisonType.EQUAL_TO, 0, false);
        condition1 = new SourceHasCounterCondition(CounterType.TIDE, ComparisonType.EQUAL_TO, 1);
        condition3 = new SourceHasCounterCondition(CounterType.TIDE, ComparisonType.EQUAL_TO, 3);
    }
}

