/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class TimecraftingAddEffect
extends OneShotEffect {
    TimecraftingAddEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put X time counters on target permanent with a time counter on it or suspended card";
    }

    private TimecraftingAddEffect(TimecraftingAddEffect effect) {
        super((OneShotEffect)effect);
    }

    public TimecraftingAddEffect copy() {
        return new TimecraftingAddEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
            Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent != null) {
                permanent.addCounters(CounterType.TIME.createInstance(xValue), source.getControllerId(), source, game);
            } else {
                Card card = game.getExile().getCard(this.getTargetPointer().getFirst(game, source), game);
                if (card != null) {
                    card.addCounters(CounterType.TIME.createInstance(xValue), source.getControllerId(), source, game);
                }
            }
            return true;
        }
        return false;
    }
}

