/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class TimecraftingRemoveEffect
extends OneShotEffect {
    TimecraftingRemoveEffect() {
        super(Outcome.Benefit);
        this.staticText = "Remove X time counters from target permanent or suspended card";
    }

    private TimecraftingRemoveEffect(TimecraftingRemoveEffect effect) {
        super((OneShotEffect)effect);
    }

    public TimecraftingRemoveEffect copy() {
        return new TimecraftingRemoveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
            Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent != null) {
                permanent.removeCounters(CounterType.TIME.createInstance(xValue), source, game);
            } else {
                Card card = game.getExile().getCard(this.getTargetPointer().getFirst(game, source), game);
                if (card != null) {
                    card.removeCounters(CounterType.TIME.createInstance(xValue), source, game);
                }
            }
            return true;
        }
        return false;
    }
}

