/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.token.SoldierToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class TimelyReinforcementsEffect
extends OneShotEffect {
    TimelyReinforcementsEffect() {
        super(Outcome.Benefit);
        this.staticText = "If you have less life than an opponent, you gain 6 life. If you control fewer creatures than an opponent, create three 1/1 white Soldier creature tokens";
    }

    private TimelyReinforcementsEffect(TimelyReinforcementsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            boolean lessCreatures = false;
            boolean lessLife = false;
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            int count = game.getBattlefield().countAll((FilterPermanent)filter, controller.getId(), game);
            for (UUID uuid : game.getOpponents(controller.getId())) {
                Player opponent = game.getPlayer(uuid);
                if (opponent != null) {
                    if (opponent.getLife() > controller.getLife()) {
                        lessLife = true;
                    }
                    if (game.getBattlefield().countAll((FilterPermanent)filter, uuid, game) > count) {
                        lessCreatures = true;
                    }
                }
                if (!lessLife || !lessCreatures) continue;
                break;
            }
            if (lessLife) {
                controller.gainLife(6, game, source);
            }
            if (lessCreatures) {
                CreateTokenEffect effect = new CreateTokenEffect((Token)new SoldierToken(), 3);
                effect.apply(game, source);
            }
            return true;
        }
        return false;
    }

    public TimelyReinforcementsEffect copy() {
        return new TimelyReinforcementsEffect(this);
    }
}

