/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.DealsCombatDamageToAPlayerTriggeredAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.StaticHint;
import mage.cards.Card;
import mage.cards.t.TimotharBaronOfBatsReturnEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.BatToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class TimotharBaronOfBatsCreateBatEffect
extends OneShotEffect {
    TimotharBaronOfBatsCreateBatEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay {1} and exile it. If you do, create a 1/1 black Bat creature token with flying. It gains \"When this creature deals combat damage to a player, sacrifice it and return the exiled card to the battlefield tapped.\"";
    }

    private TimotharBaronOfBatsCreateBatEffect(TimotharBaronOfBatsCreateBatEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card vampireCard = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (vampireCard == null) {
            return false;
        }
        ManaCostsImpl costs = new ManaCostsImpl("{1}");
        String costPromptMessage = "Pay {1} and exile " + vampireCard.getName() + "? If you do, create a create a 1/1 black Bat creature token with flying. It gains \"When this creature deals combat damage to a player, sacrifice it and return the exiled card to the battlefield tapped\".";
        if (!costs.canPay(source, source, controller.getId(), game)) {
            return false;
        }
        if (!controller.chooseUse(Outcome.Benefit, costPromptMessage, source, game)) {
            return false;
        }
        if (!costs.pay(source, game, source, controller.getId(), false)) {
            return false;
        }
        controller.moveCards(vampireCard, Zone.EXILED, source, game);
        BatToken bat = new BatToken();
        bat.putOntoBattlefield(1, game, source);
        TriggeredAbilityImpl sacAndReturnAbility = new DealsCombatDamageToAPlayerTriggeredAbility((Effect)new SacrificeSourceEffect().setText("sacrifice it"), false).setTriggerPhrase("When this creature deals combat damage to a player, ");
        sacAndReturnAbility.addEffect((Effect)new TimotharBaronOfBatsReturnEffect(new MageObjectReference((MageObject)vampireCard, game)).concatBy("and"));
        sacAndReturnAbility.addHint((Hint)new StaticHint("Exiled card: " + vampireCard.getName()));
        GainAbilityTargetEffect gainAbilityTargetEffect = new GainAbilityTargetEffect((Ability)sacAndReturnAbility, Duration.Custom);
        gainAbilityTargetEffect.setTargetPointer((TargetPointer)new FixedTargets((Token)bat, game));
        game.addEffect((ContinuousEffect)gainAbilityTargetEffect, source);
        return true;
    }

    public TimotharBaronOfBatsCreateBatEffect copy() {
        return new TimotharBaronOfBatsCreateBatEffect(this);
    }
}

