/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TinybonesTrinketThiefEffect
extends OneShotEffect {
    TinybonesTrinketThiefEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent with no cards in hand loses 10 life";
    }

    private TinybonesTrinketThiefEffect(TinybonesTrinketThiefEffect effect) {
        super((OneShotEffect)effect);
    }

    public TinybonesTrinketThiefEffect copy() {
        return new TinybonesTrinketThiefEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            if (player == null || !player.getHand().isEmpty()) continue;
            player.loseLife(10, game, source, false);
        }
        return true;
    }
}

