/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.mageobject.SharesCreatureTypePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TitanOfLittjaraEffect
extends OneShotEffect {
    TitanOfLittjaraEffect() {
        super(Outcome.DrawCard);
        this.staticText = "draw a card for each other creature you control that shares a creature type with it. If you do, discard a card.";
    }

    private TitanOfLittjaraEffect(TitanOfLittjaraEffect effect) {
        super((OneShotEffect)effect);
    }

    public TitanOfLittjaraEffect copy() {
        return new TitanOfLittjaraEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent titan = game.getPermanentOrLKIBattlefield(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (titan == null || controller == null) {
            return false;
        }
        FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("other creature you control that shares a creature type with it");
        filter.add((Predicate)new SharesCreatureTypePredicate(titan));
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        int count = game.getBattlefield().getActivePermanents((FilterPermanent)filter, controller.getId(), source, game).size();
        controller.drawCards(count, source, game);
        controller.discardOne(false, false, source, game);
        return true;
    }
}

