/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Iterator;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TitaniasSongEffect
extends ContinuousEffectImpl {
    private static final FilterArtifactPermanent filter = new FilterArtifactPermanent();

    public TitaniasSongEffect(Duration duration) {
        super(duration, Outcome.BecomeCreature);
        this.staticText = "Each noncreature artifact loses its abilities and is an artifact creature with power and toughness each equal to its mana value";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private TitaniasSongEffect(TitaniasSongEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TitaniasSongEffect copy() {
        return new TitaniasSongEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        switch (layer) {
            case TypeChangingEffects_4: {
                if (sublayer != SubLayer.NA) break;
                this.affectedObjectList.clear();
                for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                    if (permanent == null) continue;
                    this.affectedObjectList.add(new MageObjectReference((MageObject)permanent, game));
                    permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                }
                break;
            }
            case AbilityAddingRemovingEffects_6: {
                Iterator it = this.affectedObjectList.iterator();
                while (it.hasNext()) {
                    Permanent permanent = ((MageObjectReference)it.next()).getPermanent(game);
                    if (permanent == null) continue;
                    permanent.removeAllAbilities(source.getSourceId(), game);
                }
                break;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                Iterator it = this.affectedObjectList.iterator();
                while (it.hasNext()) {
                    Permanent permanent = ((MageObjectReference)it.next()).getPermanent(game);
                    if (permanent == null) continue;
                    int manaCost = permanent.getManaValue();
                    permanent.getPower().setModifiedBaseValue(manaCost);
                    permanent.getToughness().setModifiedBaseValue(manaCost);
                }
                break;
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.TypeChangingEffects_4;
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
    }
}

