/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class TogglodyteToggleEffect
extends OneShotEffect {
    TogglodyteToggleEffect() {
        super(Outcome.Neutral);
        this.staticText = "toggle {this}'s ON/OFF switch";
    }

    private TogglodyteToggleEffect(TogglodyteToggleEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            if (game.getState().getValue(mageObject.getId() + "_toggle") == null) {
                return false;
            }
            boolean toggled = Boolean.TRUE.equals(game.getState().getValue(mageObject.getId() + "_toggle"));
            game.getState().setValue(mageObject.getId() + "_toggle", (Object)(!toggled ? 1 : 0));
            ((Permanent)mageObject).addInfo("toggle", CardUtil.addToolTipMarkTags((String)("Switch: " + (!toggled ? "ON" : "OFF"))), game);
            return true;
        }
        return false;
    }

    public TogglodyteToggleEffect copy() {
        return new TogglodyteToggleEffect(this);
    }
}

