/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class ToilsOfNightAndDay
extends CardImpl {
    public ToilsOfNightAndDay(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{2}{U}");
        this.subtype.add((Object)SubType.ARCANE);
        this.getSpellAbility().addEffect((Effect)new ToilsOfNightAndDayEffect());
        this.getSpellAbility().addTarget((Target)new TargetPermanent(0, 2, new FilterPermanent(), false));
    }

    private ToilsOfNightAndDay(ToilsOfNightAndDay card) {
        super((CardImpl)card);
    }

    public ToilsOfNightAndDay copy() {
        return new ToilsOfNightAndDay(this);
    }

    private static class ToilsOfNightAndDayEffect
    extends OneShotEffect {
        public ToilsOfNightAndDayEffect() {
            super(Outcome.Tap);
            this.staticText = "You may tap or untap target permanent, then you may tap or untap another target permanent";
        }

        private ToilsOfNightAndDayEffect(ToilsOfNightAndDayEffect effect) {
            super((OneShotEffect)effect);
        }

        public ToilsOfNightAndDayEffect copy() {
            return new ToilsOfNightAndDayEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Player player = game.getPlayer(source.getControllerId());
            if (player != null) {
                for (UUID targetId : ((Target)source.getTargets().get(0)).getTargets()) {
                    Permanent permanent = game.getPermanent(targetId);
                    if (permanent == null) continue;
                    if (player.chooseUse(Outcome.Tap, "Tap " + permanent.getName() + '?', source, game)) {
                        permanent.tap(source, game);
                        continue;
                    }
                    if (!player.chooseUse(Outcome.Untap, "Untap " + permanent.getName() + '?', source, game)) continue;
                    permanent.untap(game);
                }
                return true;
            }
            return false;
        }
    }
}

