/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class TombOfTheDuskRoseEffect
extends OneShotEffect {
    TombOfTheDuskRoseEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "put a creature card exiled with this permanent onto the battlefield under your control";
    }

    private TombOfTheDuskRoseEffect(TombOfTheDuskRoseEffect effect) {
        super((OneShotEffect)effect);
    }

    public TombOfTheDuskRoseEffect copy() {
        return new TombOfTheDuskRoseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (exileZone == null || exileZone.count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game) < 1) {
            return false;
        }
        TargetCardInExile targetCard = new TargetCardInExile((FilterCard)StaticFilters.FILTER_CARD_CREATURE, exileZone.getId());
        targetCard.withNotTarget(true);
        controller.choose(this.outcome, (Target)targetCard, source, game);
        Card card = game.getCard(targetCard.getFirstTarget());
        return card != null && controller.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

