/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.TombspawnZombieToken;
import mage.players.Player;
import mage.util.CardUtil;

class TombstoneStairwellCreateTokenEffect
extends OneShotEffect {
    TombstoneStairwellCreateTokenEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "if {this} is on the battlefield, each player creates a 2/2 black Zombie creature token with haste named Tombspawn for each creature card in their graveyard";
    }

    private TombstoneStairwellCreateTokenEffect(TombstoneStairwellCreateTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public TombstoneStairwellCreateTokenEffect copy() {
        return new TombstoneStairwellCreateTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TombspawnZombieToken token = new TombspawnZombieToken();
        Player activePlayer = game.getPlayer(game.getActivePlayerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (game.getPlayer(source.getControllerId()) != null && activePlayer != null && permanent != null) {
            Object object = game.getState().getValue(CardUtil.getCardZoneString((String)"_tokensCreated", (UUID)source.getSourceId(), (Game)game));
            HashSet<UUID> tokensCreated = object != null ? (HashSet<UUID>)object : new HashSet<UUID>();
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                Player player = game.getPlayer(playerId);
                int creatureCardsInGraveyard = player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, source.getSourceId(), source, game);
                token.putOntoBattlefield(creatureCardsInGraveyard, game, source, playerId);
                for (UUID tokenId : token.getLastAddedTokenIds()) {
                    tokensCreated.add(tokenId);
                }
            }
            game.getState().setValue(CardUtil.getCardZoneString((String)"_tokensCreated", (UUID)source.getSourceId(), (Game)game), tokensCreated);
            return true;
        }
        return false;
    }
}

