/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TomikWielderOfLawTriggeredAbility
extends TriggeredAbilityImpl {
    TomikWielderOfLawTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new LoseLifeTargetEffect(3));
        this.addEffect((Effect)new DrawCardSourceControllerEffect(1));
    }

    private TomikWielderOfLawTriggeredAbility(TomikWielderOfLawTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TomikWielderOfLawTriggeredAbility copy() {
        return new TomikWielderOfLawTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player player = game.getPlayer(this.getControllerId());
        if (player != null && player.hasOpponent(game.getActivePlayerId(), game)) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(game.getCombat().getAttackingPlayerId()));
            return true;
        }
        return false;
    }

    public boolean checkInterveningIfClause(Game game) {
        return game.getCombat().getAttackers().stream().map(uuid -> game.getCombat().getDefendingPlayerId(uuid, game)).filter(this.getControllerId()::equals).count() >= 2L;
    }

    public String getRule() {
        return "Whenever an opponent attacks with creatures, if two or more of those creatures are attacking you and/or planeswalkers you control, that opponent loses 3 life and you draw a card.";
    }
}

