/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.LookLibraryAndPickControllerEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.game.Game;
import mage.game.events.GameEvent;

class TomorrowAzamisFamiliarReplacementEffect
extends ReplacementEffectImpl {
    TomorrowAzamisFamiliarReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would draw a card, look at the top three cards of your library instead. Put one of those cards into your hand and the rest on the bottom of your library in any order";
    }

    private TomorrowAzamisFamiliarReplacementEffect(TomorrowAzamisFamiliarReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TomorrowAzamisFamiliarReplacementEffect copy() {
        return new TomorrowAzamisFamiliarReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        new LookLibraryAndPickControllerEffect(3, 1, PutCards.HAND, PutCards.BOTTOM_ANY).apply(game, source);
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getControllerId());
    }
}

