/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.ExploreEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class TopographyTrackerEffect
extends ReplacementEffectImpl {
    TopographyTrackerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a creature you control would explore, instead it explores, then it explores again.";
    }

    private TopographyTrackerEffect(TopographyTrackerEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TopographyTrackerEffect copy() {
        return new TopographyTrackerEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.EXPLORE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && permanent.isControlledBy(source.getControllerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ExploreEvent exploreEvent = (ExploreEvent)event;
        exploreEvent.doubleExplores();
        return false;
    }
}

