/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class TorWaukiTheYoungerEffect
extends ReplacementEffectImpl {
    TorWaukiTheYoungerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if another source you control would deal noncombat damage to a permanent or player, it deals that much damage plus 1 to that permanent or player instead";
    }

    private TorWaukiTheYoungerEffect(TorWaukiTheYoungerEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT || event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(game.getControllerId(event.getSourceId())) && !source.getSourceId().equals(event.getSourceId()) && !((DamageEvent)event).isCombatDamage();
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)1));
        return false;
    }

    public TorWaukiTheYoungerEffect copy() {
        return new TorWaukiTheYoungerEffect(this);
    }
}

