/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.filter.common.FilterAnyTarget;
import mage.filter.common.FilterPermanentOrPlayer;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.game.Game;
import mage.game.events.DamagedBatchForOnePermanentEvent;
import mage.game.events.DamagedEvent;
import mage.game.events.DamagedPermanentEvent;
import mage.game.events.GameEvent;
import mage.target.common.TargetPermanentOrPlayer;
import mage.target.targetadjustment.DefineByTriggerTargetAdjuster;
import mage.target.targetadjustment.TargetAdjuster;

class ToralfGodOfFuryTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPermanentEvent> {
    ToralfGodOfFuryTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
        this.setTargetAdjuster((TargetAdjuster)DefineByTriggerTargetAdjuster.instance);
    }

    private ToralfGodOfFuryTriggeredAbility(ToralfGodOfFuryTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedBatchForOnePermanentEvent dEvent = (DamagedBatchForOnePermanentEvent)event;
        int excessDamage = dEvent.getEvents().stream().mapToInt(DamagedEvent::getExcess).sum();
        if (excessDamage < 1 || dEvent.isCombatDamage() || !game.getOpponents(this.getControllerId()).contains(game.getControllerId(event.getTargetId()))) {
            return false;
        }
        this.getEffects().clear();
        this.getTargets().clear();
        this.addEffect((Effect)new DamageTargetEffect(excessDamage));
        FilterAnyTarget filter = new FilterAnyTarget();
        filter.getPermanentFilter().add(Predicates.not((Predicate)new MageObjectReferencePredicate(event.getTargetId(), game)));
        this.addTarget(new TargetPermanentOrPlayer((FilterPermanentOrPlayer)filter).withChooseHint(excessDamage + " damage"));
        return true;
    }

    public ToralfGodOfFuryTriggeredAbility copy() {
        return new ToralfGodOfFuryTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature or planeswalker an opponent controls is dealt excess noncombat damage, {this} deals damage equal to the excess to any target other than that permanent.";
    }
}

