/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

class TormentOfHailfireEffect
extends OneShotEffect {
    public TormentOfHailfireEffect() {
        super(Outcome.LoseLife);
        this.staticText = "Repeat the following process X times. Each opponent loses 3 life unless that player sacrifices a nonland permanent or discards a card";
    }

    private TormentOfHailfireEffect(TormentOfHailfireEffect effect) {
        super((OneShotEffect)effect);
    }

    public TormentOfHailfireEffect copy() {
        return new TormentOfHailfireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int repeat = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
            for (int i = 1; i <= repeat; ++i) {
                for (UUID opponentId : game.getOpponents(source.getControllerId())) {
                    Player opponent = game.getPlayer(opponentId);
                    if (opponent == null) continue;
                    int permanents = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_NON_LAND, opponentId, game);
                    if (permanents > 0 && opponent.chooseUse(this.outcome, "Sacrifices a nonland permanent? (Iteration " + i + " of " + repeat + ")", "Otherwise you have to discard a card or lose 3 life.", "Sacrifice", "Discard or life loss", source, game)) {
                        Permanent permanent;
                        TargetPermanent target = new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_NON_LAND);
                        target.withNotTarget(true);
                        if (opponent.choose(this.outcome, (Target)target, source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null && permanent.sacrifice(source, game)) continue;
                    }
                    if (!opponent.getHand().isEmpty() && opponent.chooseUse(this.outcome, "Discard a card? (Iteration " + i + " of " + repeat + ")", "Otherwise you lose 3 life.", "Discard", "Lose 3 life", source, game)) {
                        opponent.discardOne(false, false, source, game);
                        continue;
                    }
                    opponent.loseLife(3, game, source, false);
                }
            }
            return true;
        }
        return false;
    }
}

