/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class TormentOfVenomEffect
extends OneShotEffect {
    TormentOfVenomEffect() {
        super(Outcome.LoseLife);
        this.staticText = "Put three -1/-1 counters on target creature. Its controller loses 3 life unless they sacrifice another nonland permanent or discards a card";
    }

    private TormentOfVenomEffect(TormentOfVenomEffect effect) {
        super((OneShotEffect)effect);
    }

    public TormentOfVenomEffect copy() {
        return new TormentOfVenomEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetCreature != null) {
            new AddCountersTargetEffect(CounterType.M1M1.createInstance(3)).apply(game, source);
            Player controllingPlayer = game.getPlayer(targetCreature.getControllerId());
            if (controllingPlayer != null) {
                int permanents = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_NON_LAND, controllingPlayer.getId(), game);
                if (permanents > 0 && controllingPlayer.chooseUse(this.outcome, "Sacrifices a nonland permanent?", "Otherwise you have to discard a card or lose 3 life.", "Sacrifice", "Discard or life loss", source, game)) {
                    Permanent permanent;
                    FilterControlledPermanent filter = new FilterControlledPermanent("another nonland permanent");
                    filter.add(Predicates.not((Predicate)CardType.LAND.getPredicate()));
                    filter.add(Predicates.not((Predicate)new PermanentIdPredicate(targetCreature.getId())));
                    TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
                    if (controllingPlayer.choose(this.outcome, (Target)target, source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null) {
                        permanent.sacrifice(source, game);
                        return true;
                    }
                }
                if (!controllingPlayer.getHand().isEmpty() && controllingPlayer.chooseUse(this.outcome, "Discard a card?", "Otherwise you lose 3 life.", "Discard", "Lose 3 life", source, game)) {
                    controllingPlayer.discardOne(false, false, source, game);
                    return true;
                }
                controllingPlayer.loseLife(3, game, source, false);
                return true;
            }
        }
        return false;
    }
}

