/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.common.PreventDamageToSourceEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class TorrentOfLavaPreventionEffect
extends PreventDamageToSourceEffect {
    private final UUID preventDamageFromId;
    private final int zoneChangeCounter;

    TorrentOfLavaPreventionEffect(UUID preventDamageFromId, int zoneChangeCounter) {
        super(Duration.EndOfTurn, 1);
        this.preventDamageFromId = preventDamageFromId;
        this.zoneChangeCounter = zoneChangeCounter;
    }

    private TorrentOfLavaPreventionEffect(TorrentOfLavaPreventionEffect effect) {
        super((PreventDamageToSourceEffect)effect);
        this.preventDamageFromId = effect.preventDamageFromId;
        this.zoneChangeCounter = effect.zoneChangeCounter;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!super.applies(event, source, game) || this.preventDamageFromId == null) {
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getSourceId());
        if (spell == null) {
            return false;
        }
        return spell.getId().equals(this.preventDamageFromId) && spell.getZoneChangeCounter(game) == this.zoneChangeCounter;
    }

    public TorrentOfLavaPreventionEffect copy() {
        return new TorrentOfLavaPreventionEffect(this);
    }
}

