/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.ActivateIfConditionActivatedAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.AttachedToMatchesFilterCondition;
import mage.abilities.condition.common.SourceHasCounterCondition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.costs.common.TapAttachedCost;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.effects.common.counter.RemoveCounterSourceEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.AttackingPredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class TourachsGate
extends CardImpl {
    private static final FilterCreaturePermanent filterAttackingCreatures = new FilterCreaturePermanent("attacking creatures you control");
    private static final FilterPermanent filterUntapped = new FilterPermanent("enchanted land is untapped");
    private static final FilterControlledPermanent filterThrull = new FilterControlledPermanent(SubType.THRULL, "a Thrull");
    private static final Condition condition;
    private static final Condition condition2;

    public TourachsGate(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{B}{B}");
        this.subtype.add((Object)SubType.AURA);
        TargetPermanent auraTarget = new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND);
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.AddAbility));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        this.addAbility((Ability)new SimpleActivatedAbility((Effect)new AddCountersSourceEffect(CounterType.TIME.createInstance(3)), (Cost)new SacrificeTargetCost((FilterPermanent)filterThrull)));
        BeginningOfUpkeepTriggeredAbility ability = new BeginningOfUpkeepTriggeredAbility((Effect)new RemoveCounterSourceEffect(CounterType.TIME.createInstance()));
        ability.addEffect((Effect)new ConditionalOneShotEffect((OneShotEffect)new SacrificeSourceEffect(), condition, "If there are no time counters on {this}, sacrifice it"));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new ActivateIfConditionActivatedAbility((Effect)new BoostAllEffect(2, -1, Duration.EndOfTurn, filterAttackingCreatures, false), new TapAttachedCost().setText("tap enchanted land"), condition2));
    }

    private TourachsGate(TourachsGate card) {
        super((CardImpl)card);
    }

    public TourachsGate copy() {
        return new TourachsGate(this);
    }

    static {
        filterAttackingCreatures.add((Predicate)AttackingPredicate.instance);
        filterAttackingCreatures.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        filterUntapped.add((Predicate)TappedPredicate.UNTAPPED);
        condition = new SourceHasCounterCondition(CounterType.TIME, ComparisonType.EQUAL_TO, 0);
        condition2 = new AttachedToMatchesFilterCondition(filterUntapped);
    }
}

