/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.AnyColorManaAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ToxicreneEffect
extends ContinuousEffectImpl {
    ToxicreneEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.LoseAbility);
        this.staticText = "all lands have \"{T}: Add one mana of any color\" and lose all other abilities";
    }

    private ToxicreneEffect(ToxicreneEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ToxicreneEffect copy() {
        return new ToxicreneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_LAND, source.getControllerId(), source, game)) {
            permanent.removeAllAbilities(source.getSourceId(), game);
            permanent.addAbility((Ability)new AnyColorManaAbility(), source.getSourceId(), game);
        }
        return true;
    }
}

