/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TrackDownEffect
extends OneShotEffect {
    TrackDownEffect() {
        super(Outcome.DrawCard);
        this.staticText = "reveal the top card of your library. If it's a creature or land card, draw a card";
    }

    private TrackDownEffect(TrackDownEffect effect) {
        super((OneShotEffect)effect);
    }

    public TrackDownEffect copy() {
        return new TrackDownEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (sourceObject == null || controller == null) {
            return false;
        }
        if (!controller.getLibrary().hasCards()) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        cards.add(card);
        controller.revealCards(sourceObject.getName(), (Cards)cards, game);
        if (card.isLand(game) || card.isCreature(game)) {
            controller.drawCards(1, source, game);
        }
        return true;
    }
}

