/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CounterAnyPredicate;
import mage.game.Game;
import mage.players.Player;

class TradeRouteEnvoyEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    TradeRouteEnvoyEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card if you control a creature with a counter on it. If you don't draw a card this way, put a +1/+1 counter on this creature";
    }

    private TradeRouteEnvoyEffect(TradeRouteEnvoyEffect effect) {
        super((OneShotEffect)effect);
    }

    public TradeRouteEnvoyEffect copy() {
        return new TradeRouteEnvoyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        if (game.getBattlefield().contains(filter, source, game, 1) && (player = game.getPlayer(source.getControllerId())) != null && player.drawCards(1, source, game) > 0) {
            return true;
        }
        Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).ifPresent(permanent -> permanent.addCounters(CounterType.P1P1.createInstance(), source, game));
        return true;
    }

    static {
        filter.add((Predicate)CounterAnyPredicate.instance);
    }
}

