/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TraitorsRoarEffect
extends OneShotEffect {
    TraitorsRoarEffect() {
        super(Outcome.Detriment);
        this.staticText = "Tap target untapped creature. It deals damage equal to its power to its controller";
    }

    private TraitorsRoarEffect(TraitorsRoarEffect effect) {
        super((OneShotEffect)effect);
    }

    public TraitorsRoarEffect copy() {
        return new TraitorsRoarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean applied = false;
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetCreature != null) {
            applied = targetCreature.tap(source, game);
            Player controller = game.getPlayer(targetCreature.getControllerId());
            if (controller != null) {
                controller.damage(targetCreature.getPower().getValue(), targetCreature.getId(), source, game);
                applied = true;
            }
        }
        return applied;
    }
}

