/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

class TranscendentDragonEffect
extends OneShotEffect {
    TranscendentDragonEffect() {
        super(Outcome.Benefit);
        this.staticText = "counter target spell. If that spell is countered this way, exile it instead of putting it into its owner's graveyard, then you may cast it without paying its mana cost";
    }

    private TranscendentDragonEffect(TranscendentDragonEffect effect) {
        super((OneShotEffect)effect);
    }

    public TranscendentDragonEffect copy() {
        return new TranscendentDragonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell == null || !game.getStack().counter(spell.getId(), source, game, PutCards.EXILED)) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        Card card = spell.getMainCard();
        if (player != null && card != null && Zone.EXILED.match(game.getState().getZone(card.getId()))) {
            CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Card)card);
        }
        return true;
    }
}

