/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.IncubateEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class TraumaticRevelationEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("creature or battle card");

    TraumaticRevelationEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent reveals their hand. You may choose a creature or battle card from it. If you do, that player discards that card. If you don't, incubate 3";
    }

    private TraumaticRevelationEffect(TraumaticRevelationEffect effect) {
        super((OneShotEffect)effect);
    }

    public TraumaticRevelationEffect copy() {
        return new TraumaticRevelationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null) {
            return false;
        }
        opponent.revealCards(source, opponent.getHand(), game);
        TargetCardInHand target = new TargetCardInHand(0, 1, filter);
        controller.choose(Outcome.Discard, opponent.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            opponent.discard(card, false, source, game);
            return true;
        }
        IncubateEffect.doIncubate((int)3, (Game)game, (Ability)source);
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.BATTLE.getPredicate()));
    }
}

