/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.choices.TwoChoiceVote;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCardInYourGraveyard;

class TravelThroughCaradhrasEffect
extends OneShotEffect {
    TravelThroughCaradhrasEffect() {
        super(Outcome.Benefit);
        this.staticText = "starting with you, each player votes for Redhorn Pass or Mines of Moria. For each Redhorn Pass vote, search your library for a basic land card and put it onto the battlefield tapped. If you search your library this way, shuffle. For each Mines of Moria vote, return a card from your graveyard to your hand";
    }

    private TravelThroughCaradhrasEffect(TravelThroughCaradhrasEffect effect) {
        super((OneShotEffect)effect);
    }

    public TravelThroughCaradhrasEffect copy() {
        return new TravelThroughCaradhrasEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TwoChoiceVote voteHandler = new TwoChoiceVote("Redhorn Pass (search for land)", "Mines of Moria (return from graveyard)", Outcome.Detriment);
        voteHandler.doVotes(source, game);
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int redhornPass = voteHandler.getVoteCount((Object)true);
        int minesOfMoria = voteHandler.getVoteCount((Object)false);
        if (redhornPass > 0) {
            new SearchLibraryPutInPlayEffect(new TargetCardInLibrary(redhornPass, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND), true).apply(game, source);
        }
        if (minesOfMoria > 0) {
            TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(Math.min(minesOfMoria, player.getGraveyard().size()));
            target.withNotTarget(true);
            player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game);
            player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.HAND, source, game);
        }
        return true;
    }
}

