/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class TreacherousGreedWatcher
extends Watcher {
    private final Set<MageObjectReference> set = new HashSet<MageObjectReference>();

    TreacherousGreedWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGED_PLAYER: 
            case DAMAGED_PERMANENT: {
                break;
            }
            default: {
                return;
            }
        }
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (permanent != null) {
            this.set.add(new MageObjectReference((MageObject)permanent, game));
        }
    }

    public void reset() {
        this.set.clear();
        super.reset();
    }

    static boolean checkCreature(Permanent permanent, Game game) {
        return ((TreacherousGreedWatcher)game.getState().getWatcher(TreacherousGreedWatcher.class)).set.contains(new MageObjectReference((MageObject)permanent, game));
    }
}

