/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TreacherousLinkEffect
extends ReplacementEffectImpl {
    TreacherousLinkEffect() {
        super(Duration.WhileOnBattlefield, Outcome.RedirectDamage);
        this.staticText = "All damage that would be dealt to enchanted creature is dealt to its controller instead";
    }

    private TreacherousLinkEffect(TreacherousLinkEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TreacherousLinkEffect copy() {
        return new TreacherousLinkEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        DamageEvent damageEvent = (DamageEvent)event;
        Permanent enchantedCreature = game.getPermanentOrLKIBattlefield(damageEvent.getTargetId());
        if (enchantedCreature == null) {
            return false;
        }
        Player controller = game.getPlayer(enchantedCreature.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.damage(damageEvent.getAmount(), damageEvent.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable(), damageEvent.getAppliedEffects());
        return true;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent enchantedCreature;
        Permanent enchantment = source.getSourcePermanentOrLKI(game);
        Player controller = game.getPlayer(source.getControllerId());
        DamageEvent damageEvent = (DamageEvent)event;
        if (controller != null && enchantment != null && (enchantedCreature = game.getPermanentOrLKIBattlefield(enchantment.getAttachedTo())) != null) {
            return enchantedCreature.getId().equals(damageEvent.getTargetId());
        }
        return false;
    }
}

