/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class TreacherousUrgeEffect
extends OneShotEffect {
    TreacherousUrgeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent reveals their hand. You may put a creature card from it onto the battlefield under your control. That creature gains haste. Sacrifice it at the beginning of the next end step";
    }

    private TreacherousUrgeEffect(TreacherousUrgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public TreacherousUrgeEffect copy() {
        return new TreacherousUrgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = game.getObject(source);
        if (opponent != null && sourceObject != null) {
            opponent.revealCards(sourceObject.getName(), opponent.getHand(), game);
            Player controller = game.getPlayer(source.getControllerId());
            if (controller != null) {
                int cardsHand = opponent.getHand().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
                Card card = null;
                if (cardsHand > 0) {
                    TargetCard target = new TargetCard(Zone.HAND, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
                    if (controller.choose(Outcome.Benefit, opponent.getHand(), target, source, game)) {
                        Permanent permanent;
                        card = opponent.getHand().get(target.getFirstTarget(), game);
                        if (card != null && controller.moveCards(card, Zone.BATTLEFIELD, source, game) && (permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)) != null) {
                            GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.Custom);
                            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                            game.addEffect((ContinuousEffect)effect, source);
                            SacrificeTargetEffect sacrificeEffect = new SacrificeTargetEffect("sacrifice " + card.getName(), source.getControllerId());
                            sacrificeEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                            AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)sacrificeEffect);
                            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
                            return true;
                        }
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }
}

