/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TreasureKeeperEffect
extends OneShotEffect {
    TreasureKeeperEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "reveal cards from the top of your library until you reveal a nonland card with mana value 3 or less. You may cast that card without paying its mana cost. Put all revealed cards not cast this way on the bottom of your library in a random order";
    }

    private TreasureKeeperEffect(TreasureKeeperEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Boolean cardWasCast = false;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && controller.getLibrary().hasCards()) {
            CardsImpl toReveal = new CardsImpl();
            Card nonLandCard = null;
            for (Card card : controller.getLibrary().getCards(game)) {
                toReveal.add(card);
                if (card.isLand(game) || card.getManaValue() >= 4) continue;
                nonLandCard = card;
                break;
            }
            controller.revealCards(source, (Cards)toReveal, game);
            if (nonLandCard != null && controller.chooseUse(Outcome.PlayForFree, "Cast " + nonLandCard.getLogName() + " without paying its mana cost?", source, game)) {
                game.getState().setValue("PlayFromNotOwnHandZone" + nonLandCard.getId(), (Object)Boolean.TRUE);
                cardWasCast = controller.cast(controller.chooseAbilityForCast(nonLandCard, game, true), game, true, new ApprovingObject(source, game));
                game.getState().setValue("PlayFromNotOwnHandZone" + nonLandCard.getId(), null);
                if (cardWasCast.booleanValue()) {
                    toReveal.remove(nonLandCard);
                }
            }
            controller.putCardsOnBottomOfLibrary((Cards)toReveal, game, source, false);
        }
        return cardWasCast;
    }

    public TreasureKeeperEffect copy() {
        return new TreasureKeeperEffect(this);
    }
}

