/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.t.TreasureNabberEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TreasureNabberAbility
extends TriggeredAbilityImpl {
    TreasureNabberAbility() {
        super(Zone.BATTLEFIELD, (Effect)new TreasureNabberEffect());
    }

    private TreasureNabberAbility(TreasureNabberAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (game.inCheckPlayableState()) {
            return false;
        }
        if (!game.getOpponents(this.controllerId).contains(event.getPlayerId())) {
            return false;
        }
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        if (permanent == null || !permanent.isArtifact(game)) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        return true;
    }

    public TreasureNabberAbility copy() {
        return new TreasureNabberAbility(this);
    }

    public String getRule() {
        return "Whenever an opponent taps an artifact for mana, gain control of that artifact until the end of your next turn.";
    }
}

