/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TreefolkUmbraEffect
extends ContinuousEffectImpl {
    TreefolkUmbraEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "and assigns combat damage equal to its toughness rather than its power";
    }

    private TreefolkUmbraEffect(TreefolkUmbraEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TreefolkUmbraEffect copy() {
        return new TreefolkUmbraEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null || permanent.getAttachedTo() == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new PermanentIdPredicate(permanent.getAttachedTo()));
        game.getCombat().setUseToughnessForDamage(true);
        game.getCombat().addUseToughnessForDamageFilter(filter);
        return true;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

