/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TrepanationBladeDiscardEffect
extends OneShotEffect {
    TrepanationBladeDiscardEffect() {
        super(Outcome.Discard);
        this.staticText = "defending player reveals cards from the top of their library until they reveal a land card. The creature gets +1/+0 until end of turn for each card revealed this way. That player puts the revealed cards into their graveyard";
    }

    private TrepanationBladeDiscardEffect(TrepanationBladeDiscardEffect effect) {
        super((OneShotEffect)effect);
    }

    public TrepanationBladeDiscardEffect copy() {
        return new TrepanationBladeDiscardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent equipment = game.getPermanent(source.getSourceId());
        if (equipment != null && equipment.getAttachedTo() != null) {
            Permanent creature = game.getPermanent(equipment.getAttachedTo());
            if (creature == null) {
                return false;
            }
            UUID defenderId = game.getCombat().getDefenderId(creature.getId());
            Player defendingPlayer = game.getPlayer(defenderId);
            if (defendingPlayer == null) {
                return false;
            }
            CardsImpl cards = new CardsImpl();
            for (Card card : defendingPlayer.getLibrary().getCards(game)) {
                cards.add(card);
                if (!card.isLand(game)) continue;
                break;
            }
            defendingPlayer.revealCards(equipment.getName(), (Cards)cards, game);
            defendingPlayer.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
            if (!cards.isEmpty()) {
                BoostTargetEffect effect = new BoostTargetEffect(cards.size(), 0, Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

