/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class TributeToHungerEffect
extends OneShotEffect {
    TributeToHungerEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Target opponent sacrifices a creature of their choice. You gain life equal to that creature's toughness";
    }

    private TributeToHungerEffect(TributeToHungerEffect effect) {
        super((OneShotEffect)effect);
    }

    public TributeToHungerEffect copy() {
        return new TributeToHungerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(source.getTargets().getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && opponent != null) {
            TargetSacrifice target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
            if (target.canChoose(opponent.getId(), source, game)) {
                opponent.choose(Outcome.Sacrifice, (Target)target, source, game);
                Permanent permanent = game.getPermanent(target.getFirstTarget());
                if (permanent != null) {
                    permanent.sacrifice(source, game);
                    controller.gainLife(permanent.getToughness().getValue(), game, source);
                }
            }
            return true;
        }
        return false;
    }
}

