/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class TriumphOfSaintKatherineEffect
extends OneShotEffect {
    TriumphOfSaintKatherineEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile it and the top six cards of your library in a face-down pile. If you do, shuffle that pile and put it back on top of your library";
    }

    private TriumphOfSaintKatherineEffect(TriumphOfSaintKatherineEffect effect) {
        super((OneShotEffect)effect);
    }

    public TriumphOfSaintKatherineEffect copy() {
        return new TriumphOfSaintKatherineEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getSourceId());
        if (player == null || card == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        if (card.getZoneChangeCounter(game) == source.getStackMomentSourceZCC()) {
            cards.add(card);
        }
        cards.addAllCards((Collection)player.getLibrary().getTopCards(game, 6));
        if (cards.isEmpty()) {
            return false;
        }
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.getCards(game).stream().forEach(c -> c.setFaceDown(true, game));
        player.putCardsOnTopOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

