/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

class TunnelTipsterWatcher
extends Watcher {
    private final Set<UUID> players = new HashSet<UUID>();

    TunnelTipsterWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && (zEvent = (ZoneChangeEvent)event).getToZone() == Zone.BATTLEFIELD && zEvent.getTarget().isCreature(game) && zEvent.getTarget().isFaceDown(game)) {
            this.players.add(zEvent.getTarget().getControllerId());
        }
    }

    public void reset() {
        super.reset();
        this.players.clear();
    }

    public static boolean faceDownCreatureEnteredForPlayer(UUID playerId, Game game) {
        return ((TunnelTipsterWatcher)game.getState().getWatcher(TunnelTipsterWatcher.class)).players.contains(playerId);
    }
}

